/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.launchConfigurations;

import com.aptana.core.logging.IdeLog;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.launchConfigurations.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class DebugSettingsTab
extends AbstractLaunchConfigurationTab {
    private Image image;
    private Button overridePrefs;
    private Button suspendOnFirstLine;
    private Button suspendOnExceptions;
    private Button suspendOnErrors;
    private Button suspendOnDebuggerKeyword;
    private ILaunchConfiguration launchConfiguration;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.overridePrefs = new Button(composite, 32);
        this.overridePrefs.setText(Messages.DebugSettingsTab_UseLaunchSpecificOptions);
        Group suspendOptionsGroup = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        suspendOptionsGroup.setLayout((Layout)gridLayout);
        suspendOptionsGroup.setLayoutData((Object)new GridData(768));
        suspendOptionsGroup.setText(Messages.DebugSettingsTab_SuspendOptions);
        this.suspendOnFirstLine = new Button((Composite)suspendOptionsGroup, 32);
        this.suspendOnFirstLine.setText(Messages.DebugSettingsTab_SuspendAtStart);
        this.suspendOnExceptions = new Button((Composite)suspendOptionsGroup, 32);
        this.suspendOnExceptions.setText(Messages.DebugSettingsTab_SuspendOnExceptions);
        this.suspendOnErrors = new Button((Composite)suspendOptionsGroup, 32);
        this.suspendOnErrors.setText(Messages.DebugSettingsTab_SuspendOnErrors);
        this.suspendOnDebuggerKeyword = new Button((Composite)suspendOptionsGroup, 32);
        this.suspendOnDebuggerKeyword.setText(Messages.DebugSettingsTab_SuspendOnDebuggerKeyword);
        Listener dirtyListener = new Listener(){

            public void handleEvent(Event event) {
                DebugSettingsTab.this.setDirty(true);
                DebugSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.overridePrefs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugSettingsTab.this.updateEnablement();
                DebugSettingsTab.this.setDirty(true);
                DebugSettingsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.suspendOnFirstLine.addListener(13, dirtyListener);
        this.suspendOnExceptions.addListener(13, dirtyListener);
        this.suspendOnErrors.addListener(13, dirtyListener);
        this.suspendOnDebuggerKeyword.addListener(13, dirtyListener);
        this.setControl((Control)composite);
    }

    private void updateEnablement() {
        boolean enableOverride = this.overridePrefs.getSelection();
        this.suspendOnFirstLine.setEnabled(enableOverride);
        this.suspendOnExceptions.setEnabled(enableOverride);
        this.suspendOnErrors.setEnabled(enableOverride);
        this.suspendOnDebuggerKeyword.setEnabled(enableOverride);
        try {
            if (enableOverride) {
                this.setValuesFrom(this.launchConfiguration);
            } else {
                this.setValuesFrom(new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.aptana.js.debug.core"));
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
    }

    private void setValuesFrom(Object object) throws CoreException {
        if (object instanceof IPreferenceStore) {
            IPreferenceStore preferences = (IPreferenceStore)object;
            this.suspendOnFirstLine.setSelection(preferences.getBoolean("com.aptana.js.debug.core.suspend_on_first_line"));
            this.suspendOnExceptions.setSelection(preferences.getBoolean("com.aptana.js.debug.core.suspend_on_exceptions"));
            this.suspendOnErrors.setSelection(preferences.getBoolean("com.aptana.js.debug.core.suspend_on_errors"));
            this.suspendOnDebuggerKeyword.setSelection(preferences.getBoolean("com.aptana.js.debug.core.suspend_on_debugger_keyword"));
        } else if (object instanceof ILaunchConfiguration) {
            ILaunchConfiguration configuration = (ILaunchConfiguration)object;
            this.suspendOnFirstLine.setSelection(configuration.getAttribute("suspendOnFirstLine", false));
            this.suspendOnExceptions.setSelection(configuration.getAttribute("suspendOnExceptions", false));
            this.suspendOnErrors.setSelection(configuration.getAttribute("suspendOnErrors", false));
            this.suspendOnDebuggerKeyword.setSelection(configuration.getAttribute("suspendOnDebuggerKeywords", false));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        JSLaunchConfigurationHelper.setDebugDefaults((ILaunchConfigurationWorkingCopy)configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        try {
            try {
                this.overridePrefs.setSelection(configuration.getAttribute("overrideDebugPreferences", false));
                this.setValuesFrom(configuration);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (String)"Reading launch configuration fails", (Throwable)e);
                this.updateEnablement();
            }
        }
        finally {
            this.updateEnablement();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("overrideDebugPreferences", this.overridePrefs.getSelection());
        if (this.overridePrefs.getSelection()) {
            configuration.setAttribute("suspendOnFirstLine", this.suspendOnFirstLine.getSelection());
            configuration.setAttribute("suspendOnExceptions", this.suspendOnExceptions.getSelection());
            configuration.setAttribute("suspendOnErrors", this.suspendOnErrors.getSelection());
            configuration.setAttribute("suspendOnDebuggerKeywords", this.suspendOnDebuggerKeyword.getSelection());
        }
    }

    public String getName() {
        return Messages.DebugSettingsTab_Debug;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = JSDebugUIPlugin.getImageDescriptor("icons/full/obj16/launch-debug.gif").createImage();
        }
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }
}

